--Kostenrechnung, Controlling

--für Anordnungsbeziehungen Projektmanagement
CREATE FUNCTION makeganttopixid(ix integer, op integer) RETURNS varchar(50) AS $$
BEGIN
  RETURN 'IX:'||ix||';OP:'||op||';';
END $$ LANGUAGE plpgsql IMMUTABLE;


 -- Typ des Projekts in anl
 CREATE TABLE anltyp
   (ant_typ             varchar(19) PRIMARY KEY,
    ant_bez             varchar(75)
  );


 CREATE TABLE kostrechgemko
  (krc_id               serial PRIMARY KEY,
   krc_bez              varchar(30),
   krc_proz             numeric,
   krc_los              numeric NOT NULL DEFAULT 1,     --Losschwelle, ab dieser Schwelle Proz-Vorgabe wählen; !! wird nirgendwo verwendet, JM, 04.08.2017 !!
   krc_autoinsert       bool NOT NULL DEFAULT FALSE   -- als Vorgabe für AVOR automatisch setzen, Achtung Kombination Bezeichnung und Losschwelle beachten
   --krc_minhsk           numeric,
   --krc_lokogemz         BOOL NOT NULL DEFAULT FALSE
  );

 CREATE TABLE anlstat
  (ans_stat             varchar(5) PRIMARY KEY,
   ans_bez              varchar(200)
  );

 CREATE TABLE anlstruktur
  (anst_id              varchar(30) PRIMARY KEY,
   anst_bem             varchar(25),
   --anst_parent_id     varchar(19), --Elternelement
   anst_descr           varchar(200) --Strukturbezeichnung
  );

 CREATE TABLE anlstrprofil
  (ansp_id              serial PRIMARY KEY,
   ansp_anst_id         varchar(30) NOT NULL REFERENCES anlstruktur ON UPDATE CASCADE,
   ansp_ident           varchar(30),                    -- Identifikator (1.1.1, 1.1.2 etc)
   ansp_parent_id       integer,                        -- Parent
   ansp_pos             integer,                        -- Positionsnummer
   ansp_descr           varchar(200),                   -- StrukturArtikel-Bezeichnung
   ansp_ap_nr           varchar(40),                    -- Artikel-Nr.wird evtl noch benötigt werden
   ansp_op_ix           integer                         -- ask-index fest vorgegeben, wenn leer dann standard-ask
  );


 CREATE OR REPLACE FUNCTION anlstrprofil__ansp_ident__a_u() RETURNS TRIGGER AS $$
    BEGIN
       UPDATE anlstr_vorgangsanordnung SET ava_parent=new.ansp_ident WHERE ava_parent=old.ansp_ident;
       UPDATE anlstr_vorgangsanordnung SET ava_child=new.ansp_ident WHERE ava_child=old.ansp_ident;
       --
       UPDATE anlstr_agsetting SET ags_anst_ident=new.ansp_ident WHERE ags_anst_ident=old.ansp_ident;
       --
       RETURN new;
    END $$ LANGUAGE plpgsql;

 CREATE TRIGGER anlstrprofil__ansp_ident__a_u
    AFTER UPDATE OF ansp_ident
    ON anlstrprofil
    FOR EACH ROW
    EXECUTE PROCEDURE anlstrprofil__ansp_ident__a_u();


 CREATE TABLE anlstr_vorgangsanordnung
  (ava_id               serial  PRIMARY KEY,
   ava_anst_id          varchar(30) REFERENCES anlstruktur ON UPDATE CASCADE ON DELETE CASCADE,
   ava_name             varchar(50),                    -- Bezeichnung, zB Versicherung nach Telefonat
   ava_parent           varchar(30),                    -- Vorgang 1 - id (1.1.1)
   ava_p_o2id           integer,
   ava_p_a2id           integer,
   --ava_p_ixop         varchar(30),                    -- ASK / AG Bezug IX:123;OP:5;
   ava_child            varchar(30),                    -- Vorgang 2 - id (1.1.2)
   ava_c_o2id           integer,
   ava_c_a2id           integer,
   --ava_c_ixop         varchar(30),                    -- ASK / AG Bezug IX:123;OP:5;
   ava_autofilllink     bool NOT NULL DEFAULT FALSE,    -- Verfollständigung von Autolinks, wo ansonsten Unterbrechung da bereits ein Link vorhanden
   ava_typ              integer,                        -- Anfang Anfang, Anfang Ende (trFinishToStart, trStartToStart, trFinishToFinish, trStartToFinish)
   ava_distance         integer,                        -- Zeitabstand
   ava_txt              TEXT                            -- Bemerkung (Lang)
  );


 CREATE TABLE anlstr_agsetting
  (ags_id               serial PRIMARY KEY,
   ags_anst_id          varchar(30) REFERENCES anlstruktur ON UPDATE CASCADE ON DELETE CASCADE,
   ags_anst_ident       varchar(30),                    -- Vorgang Id - 1.1.AG20 //Todo -> auf o2_id/a2_id umstellen
   ags_anst_ixop        varchar(30),                    -- Vorgang - ASK / AG Bezug IX:123;OP:5;
   ags_anst_stk         numeric(12,2),                  -- Menge zB 6 Stunden
   ags_anst_dauer       numeric(7,2)                    -- Dauer zB innerhalb der nächsten 20 Tage
  );
--

--Anlagen / Projektverwaltung
CREATE TABLE anl (
  an_nr                varchar(50) PRIMARY KEY,
  an_typ               varchar(19) REFERENCES anltyp ON UPDATE CASCADE,
  an_stat              varchar(5) REFERENCES anlstat ON UPDATE CASCADE, -- Freigabe
  --an_doeinkauf       BOOL NOT NULL DEFAULT FALSE,
  --an_dolager         BOOL NOT NULL DEFAULT FALSE,
  --an_print           BOOL NOT NULL DEFAULT FALSE,
  an_such              varchar(50),
  an_bez               varchar(100) NOT NULL,
  an_buchcode          varchar(40), -- Umschlüsselungscode für Buchhaltung, wenn Projekt als Kostenträger benutzt wird.
  an_ag_nr             varchar(75),
  an_ak_nr             varchar(40) REFERENCES art ON UPDATE CASCADE,
  an_best              varchar(30) REFERENCES adressen_keys ON UPDATE CASCADE,              -- Besteller
  an_hest              varchar(30) REFERENCES adressen_keys ON UPDATE CASCADE,              -- Betreiber
  an_lief              varchar(30) DEFAULT '#' REFERENCES adressen_keys ON UPDATE CASCADE,  -- Lieferant
  an_inst              varchar(30) DEFAULT '#' REFERENCES adressen_keys ON UPDATE CASCADE,  -- Installateur
  an_kund              varchar(21) REFERENCES adk ON UPDATE CASCADE,                        -- Kunde (immer Hauptadresse)
  an_sortkrz           varchar(30) REFERENCES adressen_keys ON UPDATE CASCADE,              -- Standort
  an_hdat              date, -- Inbetriebnahme / Herstelldatum
  an_ldat              date, -- Liefertermin
  an_idat              date, -- Montagetermin / Installationstermin
  an_senr              varchar(75),
  an_sort              varchar(75),
  an_text              text,
  an_text_rtf          text,
  an_at                date,
  an_et                date,
  an_ab_ix             integer,
  an_allg1             varchar(50),
  an_done              bool NOT NULL DEFAULT FALSE,    -- Projekt erledigt
  an_storno            bool NOT NULL DEFAULT FALSE,    -- Stornoflag
  an_stornogrund       text,                           -- warum wurde storniert - Pflichtfeld, Triggerpruefung.
  an_stornoby          varchar(20),                    -- durch wen wurde storniert
  an_stornodat         date,                           -- wann wurde storniert
  an_leistung          numeric(12,4),
  an_allgemein1        varchar(200),
  an_allgemein2        varchar(200),
  -- System (tables__generate_missing_fields)
  dbrid                varchar(32) NOT NULL DEFAULT nextval('db_id_seq')  -- Die dbrid benutzen wir schon für die Views, die muss also beim Erstellen der DB schon da sein.
 );

 --
 CREATE INDEX anl_an_ab_ix ON anl (an_ab_ix);
 CREATE INDEX anl_done ON anl(an_done);
 CREATE INDEX anl_storno ON anl(an_storno);


 CREATE OR REPLACE FUNCTION anl__b_i() RETURNS TRIGGER AS $$
  BEGIN
   new.an_nr:=TRIM(UPPER(new.an_nr));
   new.an_ab_ix:=nextval('abk_ab_ix_seq');
   RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER anl__b_i
   BEFORE INSERT
   ON anl
   FOR EACH ROW
   EXECUTE PROCEDURE anl__b_i();


 CREATE OR REPLACE FUNCTION anl__a_i() RETURNS TRIGGER AS $$
  BEGIN
   --struktur anlegen, falls vorgabestruktur vorhanden
   INSERT INTO abk(ab_ix, ab_inplantaf, ab_pos, ab_tablename, ab_dbrid) VALUES (new.an_ab_ix,  IFTHEN(TSystem.Settings__Get('CheckWkstPlanTermAutoPlan')=-1,true, false), 0, 'anl', new.dbrid);
   RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER anl__a_i
   AFTER INSERT
   ON anl
   FOR EACH ROW
   EXECUTE PROCEDURE anl__a_i();


 CREATE OR REPLACE FUNCTION anl__b_u__donestorno() RETURNS TRIGGER AS $$
  BEGIN
   UPDATE abk SET ab_done=TRUE WHERE NOT ab_done AND ab_ld_id IS NULL AND ab_an_nr=new.an_nr; --analog Interne Bestellung abschliessen alle offenen AG beenden
   RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER anl__b_u__donestorno
   BEFORE UPDATE OF an_done, an_storno
   ON anl
   FOR EACH ROW
   WHEN ((new.an_done AND NOT old.an_done) OR (new.an_storno AND NOT old.an_storno))
   EXECUTE PROCEDURE anl__b_u__donestorno();

 CREATE OR REPLACE FUNCTION anl__b_u_storno() RETURNS TRIGGER AS $$
  BEGIN
   --Projekt stornieren
   IF COALESCE(new.an_stornogrund,'') = '' THEN --Stornierungsgrund muss angegeben sein. Sonst Fehler.
        RAISE EXCEPTION '%', lang_text(12502);
   END IF;
   --
   new.an_stornodat := COALESCE(new.an_stornodat,current_date);
   new.an_stornoby  := COALESCE(new.an_stornoby, current_user); --Pflichtfeld, automatisch gefuehrt.
   new.an_done:=TRUE;
   --
   RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER anl__b_u_storno
   BEFORE UPDATE OF an_storno
   ON anl
   FOR EACH ROW
   WHEN (new.an_storno AND NOT old.an_storno)
   EXECUTE PROCEDURE anl__b_u_storno();


 CREATE OR REPLACE FUNCTION anl__b_d() RETURNS TRIGGER AS $$
  BEGIN
   PERFORM tplanterm.deleteabk(old.an_ab_ix);
   RETURN old;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER anl__b_d
   BEFORE DELETE
   ON anl
   FOR EACH ROW
   EXECUTE PROCEDURE anl__b_d();



 --
 CREATE OR REPLACE FUNCTION anl__a_iu_keywordsearch() RETURNS TRIGGER AS $$
  BEGIN
   PERFORM TSystem.kws_create_keywords(new.*);
   RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER anl__a_iu_keywordsearch
   AFTER INSERT OR UPDATE
   OF an_nr, an_bez, an_such, an_ag_nr, an_ab_ix, an_best, an_hest, an_lief, an_inst, an_sortkrz
   ON anl
   FOR EACH ROW
   EXECUTE PROCEDURE anl__a_iu_keywordsearch();
 --
 CREATE TRIGGER anl_delete_abk_project_structure AFTER DELETE ON anl FOR EACH ROW EXECUTE PROCEDURE table_delete_abkstru();

 CREATE OR REPLACE FUNCTION set_anl_print(varchar, bool) RETURNS bool AS $$
  BEGIN
   UPDATE anl SET an_print=$2 WHERE an_nr=$1 AND an_print<>$2;
   RETURN true;
  END $$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION anlName(annr varchar) RETURNS varchar(100) AS $$
  SELECT COALESCE(an_nr||': '||COALESCE(an_bez, ''), prodat_languages.langText(12270)) FROM public.anl WHERE an_nr=annr;
 $$ LANGUAGE sql STABLE;
--
CREATE TABLE anl_pfunktion
  (pfu_krz              varchar(10) NOT NULL PRIMARY KEY,
   pfu_bez              varchar(50)
  );


 CREATE TABLE anl_personen
  (anp_id               serial PRIMARY KEY,
   anp_an_nr            varchar(50) NOT NULL REFERENCES anl ON UPDATE CASCADE ON DELETE CASCADE,
   anp_ad_krz           varchar(21) NOT NULL REFERENCES adk ON UPDATE CASCADE,
   anp_ap_krz           varchar(21), --Kontaktansprechpartner innerhalb Adresse
   anp_funktion         varchar(10) REFERENCES anl_pfunktion ON UPDATE CASCADE,
   anp_text             text,
   anp_text_rtf         text
  );


 /*SELECT TSystem.Create_FComment(
      'TSystem.anl_projleiter'
     ,'Gibt Projekleiterinformationen zu einem Projekt zurück',
     ,'Rückgabezusatzinfo'
     ,ARRAY['annr',
                'adresskrz',
                'krzAPkrz',
                'adresskrz_apkrz',
                'adressename']
     ,ARRAY['Projektnummer',
                'Kurzname der Adresse (CIMPCS GmbH)',
                'Ansprechpartner Kürzel (Kontaktkürzel unter der Adresse) (DS)',
                'AdressKurzname.AnsprechpartnerKurzname. Achtung - nur bei Externen adresse. Bei internen wird das "#" weggelassen. "CIMPCS.DS"',
                'Ausgeschriebener Name (Daniel Schuchardt)']
     ,ARRAY['Projekt','Projektleiter','Projektleitung','Ansprechpartner']
     );*/
 --

CREATE OR REPLACE FUNCTION anl_projleiter(IN annr varchar, OUT adresskrz varchar, OUT krzAPkrz varchar, OUT adresskrz_apkrz varchar, OUT adressename varchar) AS $$
 BEGIN
  SELECT anp_ad_krz,
         anp_ap_krz,
         IFTHEN(anp_ad_krz='#', COALESCE(anp_ap_krz, anp_ad_krz),
                                anp_ad_krz || COALESCE('.'||anp_ap_krz, '')),
         adresse_apname(NULL, anp_ad_krz, anp_ap_krz, False)
  INTO   adresskrz, krzAPkrz, adresskrz_apkrz, adressename
  FROM anl_personen WHERE anp_an_nr=annr AND anp_funktion='PL' LIMIT 1; --todo -prio oder sonstiges für reihenfolge implementieren
  RETURN;
 END $$ LANGUAGE plpgsql STABLE STRICT;
 ---

 --Noch genutzt in Budgetplanung Vertrieb
 CREATE TABLE invrech
  (ir_id                serial PRIMARY KEY,
   ir_an_nr             varchar(50) NOT NULL REFERENCES anl ON UPDATE CASCADE ON DELETE NO ACTION,
   ir_year              integer,
   ir_date              date,
   ir_bez               varchar(50),
   ir_anz               numeric NOT NULL DEFAULT 1,
   ir_planbetr          numeric(12,2),
   ir_betr              numeric(12,2),
   ir_plan_umsatz       numeric(12,2),
   ir_fix               bool NOT NULL DEFAULT FALSE,
   ir_vari              bool NOT NULL DEFAULT FALSE,
   ir_details           text,
   ir_details_rtf       text,
   ir_ad_krz            varchar(21) REFERENCES adk ON UPDATE CASCADE,
   ir_ak_nr             varchar(40) REFERENCES art ON UPDATE CASCADE ON DELETE CASCADE
  );

  --- #9785
  CREATE TRIGGER invrech__a_99_iud__Auditlog
     AFTER INSERT OR DELETE OR UPDATE
     --OF
     ON invrech
     FOR EACH ROW
     EXECUTE PROCEDURE tlog.Auditlog_add_record();

CREATE TABLE vertrag
 (vtr_nr                        varchar(40) PRIMARY KEY,                                -- Vertragsnummer
  vtr_art                       varchar(80),                                            -- Vertragsart
  vtr_gegenstand                varchar(100),                                           -- Vertragsgegenstand
  vtr_bez                       varchar(100),                                           -- Vertragsbezeichnung: ausgeschriebene Variante der Überschrift und vollständigen Bezeichnung des Vertrags lt. Vertragsdokument
  vtr_krz                       varchar(21) NOT NULL REFERENCES adk ON UPDATE CASCADE,  -- Partner (Adresse)
  vtr_an_nr                     varchar(50) REFERENCES anl ON UPDATE CASCADE,           -- zug. Projekt
  vtr_dokunr                    integer,
  vtr_apint                     varchar(10) DEFAULT tsystem.current_user_ll_db_usename(),       -- REFERENCES llv in Constraints
  vtr_txt                       text,                                                   -- Freitext
  vtr_dokutxt_anf               text,                                                   -- Dokumentenkopf-text Anschreiben
  vtr_dokutxt_anf_rtf           text,
  vtr_dokutxt_end               text,                                                   -- Dokumentenkopf-text Schlusstext
  vtr_dokutxt_end_rtf           text,
  vtr_done                      bool NOT NULL DEFAULT FALSE,                            -- Erledigt
  vtr_nr_ext                    varchar(40),                                            -- externe Vertragsnummer
  vtr_apext_krzl                varchar(10),                                            -- externer AP kurz
  vtr_apext                     varchar(50),                                            -- externer AP lang
  vtr_txt_ext                   text,                                                   -- Beschreibungstext extern
  vtr_abschluss                 date DEFAULT current_date,                              -- Abschlussdatum
  vtr_beginn                    date,                                                   -- Ab wann
  vtr_ende                      date,                                                   -- Bis wann
  vtr_kuendfrist                integer,                                                -- Kündigungsfrist in Tagen
  vtr_kuendfrist_interval       interval,                                               -- Intervall Kündigungsfrist Tag, Monat
  vtr_verlfrist                 integer,                                                -- Verlängerungsfrist
  vtr_verlfrist_interval        interval,                                               -- Intervall Verlängerungsfrist Tag, Monat
  vtr_laufverl                  integer,                                                -- Laufzeitverlängerung
  vtr_laufverl_interval         interval,                                               -- Intervall Laufzeitverlängerung Monat, Jahr
  vtr_autolaufverl              bool NOT NULL DEFAULT FALSE,                            -- Automatische Vertragsverlängerung
  vtr_wert_kost                 numeric(12,4),                                          -- Vertragswert-Kosten (Einkauf)
  vtr_wert_kost_old             numeric(12,4),                                          -- Alt
  vtr_wert_erl                  numeric(12,4),                                          -- Vertragswert-Erlös  (Verkauf)
  vtr_wert_erl_old              numeric(12,4),                                          -- Alt
  -- System (tables__generate_missing_fields)
  dbrid                         varchar(32) NOT NULL DEFAULT nextval('db_id_seq'),
  insert_date                   date,
  insert_by                     varchar(32),
  modified_by                   varchar(32),
  modified_date                 timestamp(0),

  CHECK (vtr_kuendfrist > 0),
  CHECK (vtr_kuendfrist_interval IN ('1 day', '1 week', '1 mon')),
  -- beide gefüllt oder beide NULL
  CONSTRAINT vtr_kuendfrist_valid CHECK (vtr_kuendfrist IS NULL AND vtr_kuendfrist_interval IS NULL OR vtr_kuendfrist IS NOT NULL AND vtr_kuendfrist_interval IS NOT NULL),
  CHECK (vtr_verlfrist > 0),
  CHECK (vtr_verlfrist_interval IN ('1 day', '1 week', '1 mon')),
  CONSTRAINT vtr_verlfrist_valid CHECK (vtr_verlfrist IS NULL AND vtr_verlfrist_interval IS NULL OR vtr_verlfrist IS NOT NULL AND vtr_verlfrist_interval IS NOT NULL),
  CHECK (vtr_laufverl > 0),
  CHECK (vtr_laufverl_interval IN ('1 mon', '1 year')),
  CONSTRAINT vtr_laufverl_valid CHECK (vtr_laufverl IS NULL AND vtr_laufverl_interval IS NULL OR vtr_laufverl IS NOT NULL AND vtr_laufverl_interval IS NOT NULL),
  -- wenn automatische Verlängerung wahr ist, dann Laufzeitverlängerung und -Intervall nicht NULL
  CONSTRAINT vtr_autolaufverl_valid CHECK (NOT vtr_autolaufverl OR vtr_laufverl IS NOT NULL AND vtr_laufverl_interval IS NOT NULL)
 );

-- Trigger VORDEFFINIERT -> entsprechend automatischem DBRID-Trigger "{table}_set_modified" für table_modified()
 CREATE TRIGGER vertrag_set_modified
    BEFORE INSERT OR UPDATE
    ON vertrag
    FOR EACH ROW
    EXECUTE PROCEDURE table_modified();

 CREATE TRIGGER vertrag_delete_abk_project_structure
    AFTER DELETE
    ON vertrag
    FOR EACH ROW
    EXECUTE PROCEDURE table_delete_abkstru();

 -- automatisch wieder öffnen, wenn geschlossen war und Ende in Zukunft ist oder nicht angegeben
 CREATE OR REPLACE FUNCTION vertrag__b_u_autoopen() RETURNS TRIGGER AS $$
    BEGIN
      new.vtr_done := NOT (new.vtr_ende IS NULL OR new.vtr_ende >= current_date);
      RETURN new;
    END $$ LANGUAGE plpgsql;

  CREATE TRIGGER vertrag__b_u_autoopen
    BEFORE UPDATE OF vtr_ende
    ON vertrag
    FOR EACH ROW
    WHEN (new.vtr_done)
    EXECUTE PROCEDURE vertrag__b_u_autoopen();


 -- Neuberechnung nächster Termin für Vertragspos-Zyklus, Übergabe erledigt.
 CREATE OR REPLACE FUNCTION vertrag__b_50_u__wert() RETURNS TRIGGER AS $$
    BEGIN
      new.vtr_wert_kost_old := coalesce(new.vtr_wert_kost_old, old.vtr_wert_kost);
      new.vtr_wert_erl_old := coalesce(new.vtr_wert_erl_old, old.vtr_wert_erl);
      RETURN new;
    END $$ LANGUAGE plpgsql;

  CREATE TRIGGER vertrag__b_50_u__wert
    BEFORE UPDATE
    OF vtr_wert_kost, vtr_wert_erl
    ON vertrag
    FOR EACH ROW
    EXECUTE PROCEDURE vertrag__b_50_u__wert();

 -- Neuberechnung nächster Termin für Vertragspos-Zyklus, Übergabe erledigt.
 CREATE OR REPLACE FUNCTION vertrag__a_u() RETURNS TRIGGER AS $$
    BEGIN
      IF (old.vtr_beginn IS DISTINCT FROM new.vtr_beginn OR old.vtr_ende IS DISTINCT FROM new.vtr_ende) THEN
           UPDATE cycles SET
             cyc_nexterm = cycles__date_next__calculate(GREATEST(cyc_begin, new.vtr_beginn) , LEAST(cyc_end, new.vtr_ende), cyc_lasterm, cyc_interval, cyc_multi)
           FROM vertrag_pos
           WHERE vtp_vtr_nr = new.vtr_nr
            AND cyc_src_dbrid = vertrag_pos.dbrid
            AND cyc_src_key = 'vertrag_pos';
      END IF;

      IF old.vtr_done IS DISTINCT FROM new.vtr_done THEN
           UPDATE cycles SET
            cyc_done = new.vtr_done
           FROM vertrag_pos
           WHERE vtp_vtr_nr = new.vtr_nr
            AND cyc_src_dbrid = vertrag_pos.dbrid
            AND cyc_src_key = 'vertrag_pos';
      END IF;

      -- TODO: bei anderen Zyklustypen auch cyc_done koppeln (abk, ab2)

      RETURN new;
    END $$ LANGUAGE plpgsql;

  CREATE TRIGGER vertrag__a_u
    AFTER UPDATE OF vtr_beginn, vtr_ende, vtr_done
    ON vertrag
    FOR EACH ROW
    EXECUTE PROCEDURE vertrag__a_u();

/*
CREATE TABLE vertragszahlung
 (vtz_id                serial PRIMARY KEY,
  vtz_vtr_nr            VARCHAR(40) NOT NULL REFERENCES vertrag ON UPDATE CASCADE ON DELETE CASCADE,    --Vertragsnummer zu der Zahlung gehört
  vtz_date              DATE NOT NULL DEFAULT current_date,                     --Zahlungseingang
  vtz_betrag            NUMERIC(12,4),                                          --Zahlbetrag
  vtz_zahlart           VARCHAR(50),                                            --Zahlungsart (Überweisung, Scheck, ...)
  vtz_konto             VARCHAR(25),                                            --Buchungskonto
  vtz_bemtxt            text                                                    --Freier Bemerkungstext zum Zahlungseingang
 );
*/


 CREATE TABLE vertragsanlagen
  (vta_id               serial PRIMARY KEY,
   vta_nr               integer NOT NULL,
   vta_vtr_nr           varchar(40) NOT NULL REFERENCES vertrag ON UPDATE CASCADE ON DELETE CASCADE,    --Vertragsnummer
   vta_atd_dokunr       integer, -- REFERENCES auftgdokutxt ON UPDATE CASCADE,--Dok.NR der Anlage
   vta_bez              varchar(100),   --Anlagen Bezeichnung
   vta_bemtxt           text --Freier Bemerkungstext
 );


 CREATE TABLE vertrag_pos
  (vtp_id               serial PRIMARY KEY,
   vtp_vtr_nr           varchar(40) NOT NULL REFERENCES vertrag ON UPDATE CASCADE ON DELETE CASCADE,    -- Vertragsnummer
   vtp_pos              integer NOT NULL,
   vtp_type             varchar(1) NOT NULL,                                                            -- Aktionstyp: 'A' für Auftrag, 'E' für Einkauf
   vtp_bez              varchar(100),
   vtp_ak_nr            varchar(40) NOT NULL REFERENCES art ON UPDATE CASCADE,                          -- Artikel/DL für Aktion
   vtp_qty              numeric(12,4) NOT NULL,                                                         -- Menge
   vtp_mce              integer NOT NULL REFERENCES artmgc,                                             -- Mengeneinheit
   vtp_price            numeric(16,4) NOT NULL DEFAULT 0,                                               -- Preis in Basiswährung
   vtp_rabatt           numeric(5,2) NOT NULL DEFAULT 0,
   vtp_address          varchar(30) REFERENCES adressen_keys,                                           -- abweichende Lieferadresse
   vtp_apint            varchar(50),                                                                    -- interner AP
   vtp_ks               varchar(9), -- REFERENCES in X_TableConstraints -- REFERENCES ksv ON UPDATE CASCADE -- abweichende (zu art bzw. ac) Kostenstellen
   vtp_konto            varchar(12),                                                                    -- abweichende (zu art bzw. ac) Kontierung
   vtp_dokutxt          text,                                                                           -- Positionstext für Dokumente
   vtp_dokutxt_rtf      text,
   vtp_txt              text,                                                                           -- interne Bemerkungen
   vtp_bstat            varchar(2),                                                                     -- Statusweitergabe für Aktion
   -- System (tables__generate_missing_fields)
   dbrid                varchar(32) NOT NULL DEFAULT nextval('db_id_seq'),
   insert_date          date,
   insert_by            varchar(32),
   modified_by          varchar(32),
   modified_date        timestamp(0)
  );

-- Trigger VORDEFFINIERT -> entsprechend automatischem DBRID-Trigger "{table}_set_modified" für table_modified()
CREATE TRIGGER vertrag_pos_set_modified
  BEFORE INSERT OR UPDATE
  ON vertrag_pos
  FOR EACH ROW
  EXECUTE PROCEDURE table_modified();

 -- Prüfung des Zielstatus
 CREATE OR REPLACE FUNCTION vertrag_pos__a_iu_bstat() RETURNS TRIGGER AS $$
    BEGIN
      IF new.vtp_bstat IS NULL THEN RETURN new;
      ELSIF new.vtp_type = 'A' AND EXISTS(SELECT TRUE FROM auftgbs WHERE as_bstat = new.vtp_bstat) THEN RETURN new;
      ELSIF new.vtp_type = 'E' AND EXISTS(SELECT TRUE FROM ldsdokbs WHERE ls_bstat = new.vtp_bstat) THEN RETURN new;
      ELSE
           RAISE EXCEPTION '%', langtext(16216);
      END IF;
    END $$ LANGUAGE plpgsql;

 CREATE TRIGGER vertrag_pos__a_iu_bstat
    AFTER INSERT OR UPDATE OF vtp_bstat, vtp_type
    ON vertrag_pos
    FOR EACH ROW
    EXECUTE PROCEDURE vertrag_pos__a_iu_bstat();


 CREATE OR REPLACE FUNCTION vertrag_pos__b_01_iu__ak_nr__mce() RETURNS TRIGGER AS $$
    BEGIN
       -- INSERT
       IF new.vtp_mce IS NULL THEN --Standard ME für Artikel
          new.vtp_mce := tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(new.vtp_ak_nr);
       END IF;
       --
       IF tg_op = 'UPDATE' THEN
           -- die meid hat sich nicht geändert, obwohl sich der Artikel geändert hat!
           IF (new.vtp_ak_nr IS DISTINCT FROM old.vtp_ak_nr) AND (new.vtp_mce IS NOT DISTINCT FROM old.vtp_mce)
           THEN /*wir müssen natürlich auch den Mengencode mit nachziehen!*/
             new.vtp_mce := tartikel.me__convertme_for_art__by__mid(new.vtp_ak_nr, old.vtp_mce, true);
          END IF;
       END IF;

       IF new.vtp_ak_nr IS NOT NULL AND NOT TArtikel.me__art__artmgc__m_ids__valid(new.vtp_ak_nr, new.vtp_mce) THEN
          RAISE EXCEPTION     '%', Format(lang_text(13795), 'vertrag_pos', new.vtp_id::varchar, 'vtp_mce'    , new.vtp_ak_nr, new.vtp_mce::varchar);
       END IF;
       --
       RETURN new;
    END $$ LANGUAGE plpgsql;


  CREATE TRIGGER vertrag_pos__b_01_iu__ak_nr__mce
    BEFORE INSERT OR UPDATE OF vtp_ak_nr, vtp_mce
    ON vertrag_pos
    FOR EACH ROW
    WHEN (new.vtp_ak_nr IS NOT null)
    EXECUTE PROCEDURE vertrag_pos__b_01_iu__ak_nr__mce();

 --

CREATE TABLE vertrag_predefines
 (vtrp_gegenstand       varchar(100) UNIQUE,
  vtrp_vertragsart      varchar(80) UNIQUE
 );


 --Bauvertrag SunStrom
 CREATE TABLE bauvertrag
  (bvt_id               serial PRIMARY KEY,
   bvt_vtr_nr           varchar(40) REFERENCES vertrag ON UPDATE CASCADE,
   bvt_ausfuhrung       varchar(30), --Ausführung der Leistung beginnt binnen x Wochen
   bvt_fertig           varchar(50), -- Wochen der Fertigstellung
   bvt_ans              text, --Anschreiben-text
   bvt_ans_rtf          text,
   bvt_sicherheit       text, -- Sicherheitsleistungen
   bvt_sicherheit_rtf   text,
   bvt_besonders        text, -- Besonderheiten der Baustelle
   bvt_besonders_rtf    text,
   bvt_gwb              bool DEFAULT FALSE, -- Gewährleistungsbürgschaft vereinbart
   bvt_fern             bool DEFAULT FALSE, -- Fernwartung beauftragt
   bvt_telv             date -- telefonische Vereinbarung der Zahlungsmodalitäten
   /*
   bvt_vertreter        VARCHAR(50), --Auftraggeber Vertreten durch
   bvt_vaenderung       BOOL NOT NULL DEFAULT FALSE, --Vertreter berechtigt zu Vertragsänderungen
   bvt_auftsumme        NUMERIC(5,2), --Prozent der Auftragssumme
   bvt_abnahme          BOOL NOT NULL DEFAULT FALSE, --Vertreter berechtigt zur Abnahme
   bvt_rvertrag         BOOL NOT NULL DEFAULT FALSE, --Rechte bestimmen sich nach Vertrag
   bvt_rangebot         BOOL NOT NULL DEFAULT FALSE, --Rechte bestimmen sich nach einem bestimmten Angebot
   bvt_rplan            BOOL NOT NULL DEFAULT FALSE, --Rechte bestimmen sich nach Plänen
   bvt_rplannr          VARCHAR(40), --Pläne mit den Nummern
   bvt_rplananlnr       VARCHAR(25), --Anlagen mit den Nummern
   bvt_rzuvb            BOOL NOT NULL DEFAULT FALSE, --Rechte bestimmen sich nach zusätzl. Vertragsbedingungen
   bvt_rzuvbanlnr       VARCHAR(25), --Anlagen mit den Nummern
   bvt_rzutv            BOOL NOT NULL DEFAULT FALSE, --Rechte bestimmen sich nach zusätzl. techn. Vorschriften
   bvt_rzutvanlnr       VARCHAR(25), --Anlagen mit den Nummern
   bvt_vob              BOOL NOT NULL DEFAULT FALSE, --Rechte bestimmen sich nach VOB/B Anlage Nr1
   bvt_bgb              BOOL NOT NULL DEFAULT FALSE, --Rechte bestimmen sich nach §§631 ff. BGB
   bvt_displays         NUMERIC(12,4), -- Summe Displays Wechselrichter
   bvt_garantie         NUMERIC(12,4), -- Summe verlängerte Garantie
   bvt_vstrafe          BOOL NOT NULL DEFAULT FALSE, -- Vertragsstrafe nicht vereinbart
   bvt_vwartung         BOOL NOT NULL DEFAULT FALSE, -- Wartungsvertrag für Dauer der Verjährungsfrist
   bvt_vgarantie        BOOL NOT NULL DEFAULT FALSE, -- Verlängerte Garantie vereinbart
   bvt_anlfern          BOOL NOT NULL DEFAULT FALSE --nach "Anlage zur Fernwartung"
   */
 );


 -- keine leeren Statements am Ende vom Erstellen der DB erlaubt.
SELECT TRUE;
